// converter.js

// Only define once to prevent redeclaration errors
if (!window.sylotiConverterInitialized) {
  window.sylotiConverterInitialized = true;

  // Import the alphabets map (if using modules, else copy this structure here)
  const alphabets = {
    vowels: [
      { bangla: 'অ', syloti: 'ꠅ' },
      { bangla: 'আ', syloti: 'ꠀ' },
      { bangla: 'ই', syloti: 'ꠁ' },
      { bangla: 'ঈ', syloti: 'ꠁ' },
      { bangla: 'উ', syloti: 'ꠃ' },
      { bangla: 'ঊ', syloti: 'ꠃ' },
      { bangla: 'এ', syloti: 'ꠄ' },
      { bangla: 'ঐ', syloti: 'ꠅꠁ' },
      { bangla: 'ও', syloti: 'ꠅ' },
      { bangla: 'ঔ', syloti: 'ꠅꠃ' }
    ],
    consonants: [
      { bangla: 'ক', syloti: 'ꠇ' },
      { bangla: 'খ', syloti: 'ꠈ' },
      { bangla: 'গ', syloti: 'ꠉ' },
      { bangla: 'ঘ', syloti: 'ꠊ' },
      { bangla: 'ঙ', syloti: 'ꠋ' },
      { bangla: 'চ', syloti: 'ꠌ' },
      { bangla: 'ছ', syloti: 'ꠍ' },
      { bangla: 'জ', syloti: 'ꠎ' },
      { bangla: 'ঝ', syloti: 'ꠏ' },
      { bangla: 'ট', syloti: 'ꠐ' },
      { bangla: 'ঠ', syloti: 'ꠑ' },
      { bangla: 'ড', syloti: 'ꠒ' },
      { bangla: 'ঢ', syloti: 'ꠓ' },
      { bangla: 'ত', syloti: 'ꠔ' },
      { bangla: 'থ', syloti: 'ꠕ' },
      { bangla: 'দ', syloti: 'ꠖ' },
      { bangla: 'ধ', syloti: 'ꠗ' },
      { bangla: 'ন', syloti: 'ꠘ' },
      { bangla: 'প', syloti: 'ꠙ' },
      { bangla: 'ফ', syloti: 'ꠚ' },
      { bangla: 'ব', syloti: 'ꠛ' },
      { bangla: 'ভ', syloti: 'ꠜ' },
      { bangla: 'ম', syloti: 'ꠝ' },
      { bangla: 'য', syloti: 'ꠎ' },
      { bangla: 'র', syloti: 'ꠞ' },
      { bangla: 'ড়', syloti: 'ꠠ' },
      { bangla: 'ঢ়', syloti: 'ꠠ' },
      { bangla: 'য়', syloti: 'ꠅ' },
      { bangla: 'ল', syloti: 'ꠟ' },
      { bangla: 'শ', syloti: 'ꠡ' },
      { bangla: 'স', syloti: 'ꠡ' },
      { bangla: 'ষ', syloti: 'ꠡ' },
      { bangla: 'হ', syloti: 'ꠢ' }
    ],
    numbers: [
      { bangla: '০', syloti: '০' }, { bangla: '১', syloti: 'I' }, { bangla: '২', syloti: 'ᚴ' }, { bangla: '৩', syloti: '৩' },
      { bangla: '৪', syloti: 'ᑲ' }, { bangla: '৫', syloti: '☽' }, { bangla: '৬', syloti: 'ᑯ' }, { bangla: '৭', syloti: 'V' },
      { bangla: '৮', syloti: '8' }, { bangla: '৯', syloti: '৭' }
    ],
    vowelSigns: [
      { bangla: 'া', syloti: 'ꠣ' }, { bangla: 'ি', syloti: 'ꠤ' }, { bangla: 'ী', syloti: 'ꠤ' },
      { bangla: 'ু', syloti: 'ꠥ' }, { bangla: 'ূ', syloti: 'ꠥ' }, { bangla: 'ে', syloti: 'ꠦ' },
      { bangla: 'ো', syloti: 'ꠧ' }, { bangla: 'ৈ', syloti: 'ꠧꠁ' }, { bangla: 'ৌ', syloti: 'ꠧꠃ' },
      { bangla: '্', syloti: '꠆' }
    ]
  };

  // Create a flat Syloti → Bangla map
  window.sylotiToBanglaMap = {};
  for (const group of Object.values(alphabets)) {
    for (const item of group) {
      window.sylotiToBanglaMap[item.syloti] = item.bangla;
    }
  }

  // Conversion function
  window.convertSylotiToBangla = function(text) {
    return text.replace(/[\uA800-\uA82F]/g, char => window.sylotiToBanglaMap[char] || char);
  };

  // Walk and replace text
  window.walk = function(node) {
    let child = node.firstChild;
    while (child) {
      const next = child.nextSibling;
      if (child.nodeType === 3) { // Text node
        const old = child.nodeValue;
        if (/[\uA800-\uA82F]/.test(old)) {
          child.nodeValue = window.convertSylotiToBangla(old);
        }
      } else if (child.nodeType === 1 || child.nodeType === 11) { // Element or fragment
        window.walk(child);
      }
      child = next;
    }
  };
}
