function walk(node) {
  let child, next;
  switch (node.nodeType) {
    case 1: // Element
    case 9: // Document
    case 11: // Document fragment
      child = node.firstChild;
      while (child) {
        next = child.nextSibling;
        walk(child);
        child = next;
      }
      break;

    case 3: // Text node
      handleText(node);
      break;
  }
}

function handleText(textNode) {
  let oldText = textNode.nodeValue;
  if (/[\uA800-\uA82F]/.test(oldText)) {
    let newText = convertSylotiToBangla(oldText);
    textNode.nodeValue = newText;
  }
}

walk(document.body);
