# Syloti to Bangla Converter

**Version:** 1.0  
**Author:** Sabbir Ahmed Shawon  
**Website:** [https://syloti.vercel.app](https://syloti.vercel.app)  

---

## Description

The **Syloti to Bangla Converter** is a Google Chrome extension that automatically converts **Syloti Nagri** text to **Bangla** on any webpage.  

When the extension is enabled, all Syloti Nagri letters on the current webpage are instantly replaced with their Bangla equivalents, making it easier to read content written in Syloti Nagri script.

---

## Features

- Converts **Syloti Nagri letters** to Bangla in real-time.
- Works on **any website**.
- Easy to use via a **popup button**.
- Lightweight and fast — no internet connection required for conversion.
- Supports vowels, consonants, numbers, and vowel signs.

---

## Installation

### 1. Install Locally (Developer Mode)

1. Download or clone this repository.
2. Open Chrome and go to `chrome://extensions/`.
3. Enable **Developer mode** (top-right corner).
4. Click **Load unpacked** and select the extension folder.
5. The extension will appear in your toolbar.

### 2. Chrome Web Store

Once approved, you can install it directly from the [Chrome Web Store](#) (link available after publishing).

---

## Usage

1. Navigate to any webpage containing **Syloti Nagri text**.
2. Click the **extension icon** in the toolbar.
3. Press the **Convert** button in the popup.
4. The page will instantly update, showing Bangla text instead of Syloti Nagri.

---

## Mapping

The extension supports the full Syloti Nagri alphabet including:

- **Vowels**  
- **Consonants**  
- **Numbers**  
- **Vowel signs**

The mapping is based on the `alphabets.js` dataset included in the extension.

---

## Contributing

Contributions are welcome! If you notice missing characters or want to improve the mapping, please submit a pull request.

---

## License

This project is **open source** and free to use.  
© 2025 Sabbir Ahmed Shawon
